module.exports = function(grunt) {

	grunt.config('copy', {
		dev: {
			files: [{
				expand: true,
				dot: true,
				cwd: '<%= yeoman.app %>',
				dest: '<%= yeoman.dist %>',
				src: [
					'**/*.json',
					'**/*.js',
					'**/*.html',
					'src/**/*.css',
                    'favicon.ico',
                    '_assets/pdfs/*',
					'!index*.html',
					'_assets/fonts/**/*',
					'!_assets/fonts/**/*.html',
					'!_assets/fonts/**/*.css',
					'!**/*_spec.js'
				]
			},{
                expand: true,
                dot: true,
                cwd: '<%= yeoman.app %>',
                dest: '<%= yeoman.dist %>/_assets/fonts',
                src: [
                    'libs/sass-bootstrap/fonts/*extended*.*'
                ],
                flatten: true
            }]
		},
		dist: {
			files: [{
				expand: true,
				dot: true,
				cwd: '<%= yeoman.app %>',
				dest: '<%= yeoman.dist %>',
				src: [
					'**/*.json',
					'**/*.html',
                    'favicon.ico',
                    '_assets/pdfs/*',
					'!index*.html',
					'src/**/*.css',
					'_assets/fonts/**/*',
					'!_assets/fonts/**/*.html',
					'!_assets/fonts/**/*.css'
				]
			},{
                expand: true,
                dot: true,
                cwd: '<%= yeoman.app %>',
                dest: '<%= yeoman.dist %>/_assets/fonts',
                src: [
                    'libs/sass-bootstrap/fonts/*extended*.*'
                ],
                flatten: true
            }]
		}
	});

	grunt.loadNpmTasks('grunt-contrib-copy');

};